#!/bin/bash

cdir=$(pwd)
prog=$(basename $0)
#-------------------------------------------------------------------------------------------
# If you want newlines, you have to echo "$USAGE" and not echo $USAGE
USAGE="\
Usage: ${prog} <omega_0> <omega> <gamma> <A> <STEPS> <t_f> <x_0> <v_0> <t_trans>
        t_trans: Number of steps to ommit from analysis"
#-------------------------------------------------------------------------------------------
set -u
if(( $# != 9 ));then echo "$USAGE";exit;fi  # If arguments are necessary, uncomment this line
#-------------------------------------------------------------------------------------------
#Test:
#> ./fdp.sh  1 2 0.2 1.4 40000 2000 3.1 0 1500
 omega0=$1 # 1.0
  omega=$2 # 2.0
  gamma=$3 # 0.2
     a0=$4 # 1.4
  STEPS=$5 # 40000
     TF=$6 #  2000
     X0=$7 # 3.1
     V0=$8 # 0
t_trans=$9 # 1500


gfortran -O2 fdp.f90 -o fdp
./fdp <<EOF
$omega0  $omega $gamma $a0         omega_0, omega, gamma, A
$STEPS   0.0    $TF    $X0  $V0    STEPS,T0,TF,X0,V0
EOF

mv fdp.dat tmp.fdp.dat
awk -v tt=$t_trans '/#/{print} $1>tt{print}' tmp.fdp.dat > fdp.dat
\rm tmp.fdp.dat
gnuplot -d -p  <<EOF
set term qt 1
plot "fdp.dat" using 1:2 with dots  title "x(t)"
set term qt 2
plot "fdp.dat" using 1:3 with lines title "v(t)"
set term qt 3
plot "fdp.dat" using 1:4 with lines title "E(t)"
set term qt 4
set size square
plot "fdp.dat" using 2:3 with dots  title "x-v"
# poincare plot:
set term qt 5
plot "<awk -v o=$omega -v s=$STEPS -v tf=$TF 'BEGIN{T=6.283185307179/o;dt=tf/s;}\$1%T<dt' fdp.dat" using 2:3 with points pt 20 ps 1  title "Poincare"
EOF

echo "Close all gnuplot windows: killall gnuplot_qt"
