#!/bin/bash

cdir=`pwd`
prog=`basename $0`
#-------------------------------------------------------------------------------------------
# Defaults:
skip=1
x="" ; X=""
y="" ; Y=""
tdelay="pause 0.05"
range=0
findrange=0
#-------------------------------------------------------------------------------------------
# If you want newlines, you have to echo "$USAGE" and not echo $USAGE
USAGE="\
Usage: ${prog} -t [sleep time] -d [skip points] <file>
Default file is rk4.dat
Other options:
   -x: set lower value in xrange
   -X: set lower value in xrange
   -y: set lower value in yrange
   -Y: set lower value in yrange
   -r: automatic determination of x-y range
"
#-------------------------------------------------------------------------------------------
set -u # Undo: set +u    Treat unset variables and parameters other than the special parameters "@" and "*" as an error 
while getopts :ht:d:x:y:X:Y:r opt_char; do
 case $opt_char in
  x)  echo "Option x is called"                                 ;;
  t)  tdelay="pause $OPTARG"                                    ;;
  x)  x=$OPTARG;range=1                                         ;;
  y)  y=$OPTARG;range=1                                         ;;
  X)  X=$OPTARG;range=1                                         ;;
  Y)  Y=$OPTARG;range=1                                         ;;
  d)  skip=$OPTARG                                              ;;
  r)  findrange=1                                               ;;                    
  h)  echo "$USAGE"                                     ;exit 1 ;;
 \?)  echo "$OPTARG is not a valid option";echo "$USAGE";exit 1 ;;
 esac
done
shift $((OPTIND-1))
#-------------------------------------------------------------------------------------------
if(( $# >= 1 ));then
 file=$1
else
 file=rk4.dat
fi

if(( $range == 1 ));then
 xyrange="[${x}:${X}][${y}:${Y}]"
else
 xyrange=""
fi

if(( $findrange == 1 ));then
 xy=$(awk 'BEGIN{x=1e200;X=-x;y=x;Y=X}{if($2<x){x=$2};if($2>X){X=$2};if($3<y){y=$3};if($3>Y){Y=$3};}END{dx=0.03*(X-x);dy=0.03*(Y-y);printf "[%g:%g][%g:%g]",x-dx,X+dx,y-dy,Y+dy}' $file)
 xyrange="$xy"
fi


# ##########################################################
# This is the heart of the script. You can skip all of the
# above if you do not care about options and determinint the
# plot range
############################################################

nlines=`wc -l $file|awk '{print $1}'` 

gnuplot -persist -d <<EOF
icount = 10
set size square
set size ratio -1
do for [i=10+$skip:$nlines:$skip]{ plot $xyrange sprintf("<awk 'NR<%d' $file",i) u 2:3 w l notitle; $tdelay}
EOF

#  ---------------------------------------------------------------------
#  Copyright by Konstantinos N. Anagnostopoulos (2004-2021)
#  Physics Dept., National Technical University,
#  konstant@mail.ntua.gr, www.physics.ntua.gr/~konstant
#  
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, version 3 of the License.
#  
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#  
#  You should have received a copy of the GNU General Public Liense along
#  with this program.  If not, see <http://www.gnu.org/licenses/>.
#  -----------------------------------------------------------------------



